/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import cz.insophy.inplan.shop.Workplace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class CapabilityIsland {
    private final String name;
    private final Set<String> capabilities;
    private final List<Workplace> workplaces;

    protected CapabilityIsland(@Nonnull List<Workplace> workplaces, @Nonnull Collection<String> capabilities, @Nonnull Set<String> existingNames) {
        Preconditions.checkNotNull(workplaces);
        Preconditions.checkNotNull(capabilities);
        Preconditions.checkNotNull(existingNames);
        Preconditions.checkArgument(!workplaces.isEmpty());
        Preconditions.checkArgument(!capabilities.isEmpty());
        this.workplaces = ImmutableList.copyOf(workplaces);
        this.capabilities = ImmutableSet.copyOf(capabilities);
        this.name = CapabilityIsland.createIslandName(workplaces, existingNames);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.workplaces.get(0).getDescription();
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public List<Workplace> getWorkplaces() {
        return this.workplaces;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("capabilities", this.capabilities).add("workplaces", this.workplaces).toString();
    }

    private static String createIslandName(List<Workplace> workplaces, Set<String> existingNames) {
        Object name;
        if (workplaces.size() > 1) {
            ArrayList<String> names = Lists.newArrayListWithCapacity(workplaces.size());
            for (Workplace wp : workplaces) {
                names.add(wp.getName());
            }
            name = CapabilityIsland.createCompoundName(names);
        } else {
            name = workplaces.get(0).getName();
        }
        String proposedName = name;
        int i = 1;
        while (existingNames.contains(name)) {
            name = proposedName + "_" + i;
            ++i;
        }
        return name;
    }

    @VisibleForTesting
    static String createCompoundName(List<String> names) {
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        int totalLength = 0;
        for (String name : names) {
            int l = name.length();
            totalLength += l;
            if (l < minLength) {
                minLength = l;
            }
            if (l <= maxLength) continue;
            maxLength = l;
        }
        int lcpLen = 0;
        String name0 = names.get(0);
        block1: for (int i = 0; i < minLength; ++i) {
            lcpLen = i;
            for (String name : names) {
                if (name.charAt(i) == name0.charAt(i)) continue;
                break block1;
            }
        }
        boolean trimmedSep = false;
        while (lcpLen > 0 && name0.charAt(lcpLen - 1) == ':') {
            --lcpLen;
            trimmedSep = true;
        }
        Object res = lcpLen >= maxLength / 2 && lcpLen > 3 || trimmedSep ? names.get(0).substring(0, lcpLen) : (totalLength < 20 ? Joiner.on(", ").join(names) : names.get(0) + " - " + names.get(names.size() - 1));
        return res;
    }
}

